

Imports System
Imports System.Diagnostics
Imports System.Drawing
Imports System.Windows.Forms
Imports System.Runtime.InteropServices

Public Class frmUSB


    ' vendor and product IDs
    Private Const VendorID As Integer = 1240    'Replace with your device's (04D8)
    Private Const ProductID As Integer = 129      'product and vendor IDs   (0081)

    ' read and write buffers
    Private Const BufferInSize As Byte = 64 'Size of the data buffer coming IN to the PC
    Private Const BufferOutSize As Byte = 64    'Size of the data buffer going OUT from the PC
    Dim BufferIn(BufferInSize) As Byte    'Received data will be stored here - the first byte in the array is unused
    Dim BufferOut(BufferOutSize) As Byte   'Transmitted data is stored here - the first item in the array must be 0

    Dim m_performanceCounterCategory As PerformanceCounterCategory
    Dim Network_performanceCounter As PerformanceCounter
    Dim Network_performanceCounter2 As PerformanceCounter
    Dim timer1 As Timer = New Timer()

    Dim Download_kb As Integer
    Dim Upload_kb As Integer
    Dim CPU_Info As Integer
    Dim RAM_Info As Integer
    Dim NIC_instances As String()
    Dim Network_card_selected As Boolean
    Dim NIC_instances_name As String
    Dim saved_nic_instance_name As String


    Private Sub frmUSB_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        ' ****************************************************************
        ' when the form loads, connect to the HID controller - pass
        ' the form window handle so that you can receive notification
        ' events...
        '*****************************************************************

        ContextMenuStrip1.Enabled = True
        Message_TextBox.Text = My.Settings.Custom_message 'Va chercher le dernier message rentr
        Netword_card_listing()

        ConnectToHID(Me)



        

    End Sub
    Private Sub frmUSB_Resize(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Resize
        If Me.WindowState = FormWindowState.Minimized Then
            NotifyIcon1.Visible = True
            Me.Hide()
        End If
    End Sub

    '*****************************************************************
    ' disconnect from the HID controller...
    '*****************************************************************
    Public Sub frmUSB_FormClosed(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed

        My.Settings.Network_card_selected = NIC_instances_name 'Enregistre le nom de la carte rseau dans my settings
        My.Settings.Custom_message = Message_TextBox.Text
        My.Settings.Save()
        LCD_Host_disconnected_label()
        DisconnectFromHID()

    End Sub

    '*****************************************************************
    ' a HID device has been plugged in...
    '*****************************************************************
    Public Sub OnPlugged(ByVal pHandle As Integer)

        If hidGetVendorID(pHandle) = VendorID And hidGetProductID(pHandle) = ProductID Then

            Set_LCD_Label()

            'set-up timers
            timer1.Interval = 1000 '1000ms = 1s
            timer1.Enabled = True 'start timer
            AddHandler timer1.Tick, AddressOf Timer1_Tick 'add handler


            USB_Status_box.ForeColor = Color.Green
            USB_Status_box.Text = "USB connected"

        Else
            USB_Status_box.ForeColor = Color.Red
            USB_Status_box.Text = "NOT CONNECTED!"

        End If

    End Sub

    '*****************************************************************
    ' a HID device has been unplugged...
    '*****************************************************************
    Public Sub OnUnplugged(ByVal pHandle As Integer)
        If hidGetVendorID(pHandle) = VendorID And hidGetProductID(pHandle) = ProductID Then
            hidSetReadNotify(hidGetHandle(VendorID, ProductID), False)

            USB_Status_box.ForeColor = Color.Red
            USB_Status_box.Text = "NOT CONNECTED!"

        End If
    End Sub

    '*****************************************************************
    ' controller changed notification - called
    ' after ALL HID devices are plugged or unplugged
    '*****************************************************************
    Public Sub OnChanged()
        ' get the handle of the device we are interested in, then set
        ' its read notify flag to true - this ensures you get a read
        ' notification message when there is some data to read...
        Dim pHandle As Integer
        pHandle = hidGetHandle(VendorID, ProductID)
        hidSetReadNotify(hidGetHandle(VendorID, ProductID), True)

        If hidGetVendorID(pHandle) = VendorID And hidGetProductID(pHandle) = ProductID Then
            USB_Status_box.ForeColor = Color.Green
            USB_Status_box.Text = "USB connected"

        Else
            USB_Status_box.ForeColor = Color.Red
            USB_Status_box.Text = "NOT CONNECTED!"

        End If


    End Sub

    'Essentiel pour qu'on puisse monter le volume lorsque le PIC envoie l commnde
    Public Declare Sub keybd_event Lib "user32" (ByVal bVk As Byte, ByVal bScan As Byte, ByVal dwFlags As Integer, ByVal dwExtraInfo As Integer)
    Const KEYEVENTF_KEYUP As Long = &H2


    '*****************************************************************
    ' on read event...
    '*****************************************************************
    Public Sub OnRead(ByVal pHandle As Integer)
        ' first byte is the report ID, e.g. BufferIn(0)
        ' the other bytes are the data from the microcontroller...
        ' read the data (don't forget, pass the whole array)...


        If hidRead(pHandle, BufferIn(0)) Then

            'Volume up
            Try

                If BufferIn(2) = 45 Then
                    timer1.Enabled = False 'arrete le timer temporairement
                    Call keybd_event(Keys.VolumeUp, 0, 0, 0)
                    timer1.Enabled = True  'repart le timer
                End If

            Catch ex As Exception

            End Try


            Try
                'Volume(down)
                If BufferIn(2) = 46 Then
                    timer1.Enabled = False 'arrete le timer temporairement
                    Call keybd_event(Keys.VolumeDown, 0, 0, 0)
                    timer1.Enabled = True   'repart le timer
                End If

            Catch ex As Exception

            End Try

        End If

    End Sub

    'le timer de 1 seconde est arriv on crit les donnes au LCD et  L'application

    Public Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs)

        'Send Total CPU usage to host app
        CPU_Info = Performance_CPU_Counter.NextValue
        Progress_CPU_Bar.Value = CPU_Info
        CPU_label.Text = CPU_Info.ToString + " %"
        'Send Total CPU usage to LCD

        Move_cursor(0, 0)
        outputString(String.Concat("CPU:", Convert.ToString(CPU_Info), "%  "))

        'Send Total Physical RAM usage
        RAM_Info = (My.Computer.Info.TotalPhysicalMemory - My.Computer.Info.AvailablePhysicalMemory) / My.Computer.Info.TotalPhysicalMemory * 100
        Progress_Ram_bar.Value = RAM_Info
        Memory_label.Text = RAM_Info.ToString + " %"
        'Send Total RAM usage to LCD
        Move_cursor(8, 0)
        outputString(String.Concat("RAM:", Convert.ToString(RAM_Info), "%  "))

        'Total des KB/s on network interface
        If Network_card_selected = True Then

            Download_kb = (Network_performanceCounter.NextValue.ToString) / 1024
            Upload_kb = (Network_performanceCounter2.NextValue.ToString) / 1024

            If Download_kb > 0 Then
                Download_kb = Math.Round(Download_kb, 3)
                Download_label.Text = Download_kb.ToString + " KO/s"

            End If

            If Upload_kb > 0 Then

                Upload_kb = Math.Round(Upload_kb, 3)
                Upload_label.Text = Upload_kb.ToString + " KO/s"
            End If

            Write_bandwidht_to_lcd()

        End If



    End Sub

    Private Sub ExitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExitToolStripMenuItem.Click
        timer1.Stop()
        NotifyIcon1.Visible = False
        LCD_Host_disconnected_label()
        Me.Close()
    End Sub

    Private Sub NotifyIcon1_MouseDoubleClick(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles NotifyIcon1.MouseDoubleClick
        Me.Show()
        Me.WindowState = FormWindowState.Normal
    End Sub

    Private Sub ShowFormToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ShowToolStripMenuItem.Click
        Me.Show()
        Me.WindowState = FormWindowState.Normal
    End Sub

    Dim enc_string_Text As New System.Text.UTF8Encoding()
    Dim bt_string_Text() As Byte
    Dim LCD_STRING_OUTPUT As String

    Private Sub Set_LCD_Label()

        'Set labels for LCD

        Clear_Display()
        Move_cursor(0, 1)
        outputString("D:")
        Move_cursor(8, 1)
        outputString("U:")
        Move_cursor(14, 1)
        outputString("Ko")

    End Sub

    Private Sub LCD_Host_disconnected_label()

        'Set labels for LCD

        Clear_Display()

        If Message_CheckBox.Checked = True Then 'Si la message box est coch enleve le scolling

            Scrolling() 'Disable scrolling by togling status

        End If

        Move_cursor(4, 0)
        outputString("LCD HOST")
        Move_cursor(2, 1)
        outputString("DISCONNECTED")


    End Sub

    Private Sub Netword_card_listing()
        'list network card name and list them in combobox
        Dim m_performanceCounterCategory As PerformanceCounterCategory
        m_performanceCounterCategory = New PerformanceCounterCategory("Network Interface")
        NIC_instances = m_performanceCounterCategory.GetInstanceNames()

        'Rempli NIC_SELECT_COMBO_BOX de la liste des cartes rseau
        For I = 0 To (NIC_instances.Length - 1)

            NIC_SELECT_COMBO_BOX.Items.Add(NIC_instances(I))

        Next I


        saved_nic_instance_name = My.Settings.Network_card_selected 'Va chercher la derniere carte rseau utilis

        For Each str As String In NIC_instances

            If str.Contains(saved_nic_instance_name) Then  'si la carte rseau existe

                Network_card_selected = True

                NIC_SELECT_COMBO_BOX.SelectedItem = saved_nic_instance_name 'Selectionne la carte rseau dans la combo box

            End If


        Next

        If (Network_card_selected = True) Then

            NIC_instances_name = saved_nic_instance_name
            Network_NIC_Name()
        Else


            If (NIC_instances Is Nothing) Then             'No Network card found

                Network_card_selected = False
                MsgBox("Aucune carte rseau dtect")
            Else

                NIC_instances_name = NIC_instances(1)              'default network card
                NIC_SELECT_COMBO_BOX.SelectedItem = NIC_instances_name 'Selectionne la carte rseau dans la combo box
                Network_NIC_Name()


            End If

        End If


    End Sub

    Public Sub outputString(ByVal LCD_STRING_OUTPUT)

        ' Output a string to the LCD display

        ' Encode the passed string into an array of bytes for transfer
        bt_string_Text = enc_string_Text.GetBytes(LCD_STRING_OUTPUT)


        'Byte 0 must be set to 0
        BufferOut(0) = 0

        ' Byte 1 must be set to our command
        BufferOut(1) = &H81

        ' Byte 2 is our character count
        BufferOut(2) = bt_string_Text.Length


        ' Copy the characters from the string into the output buffer

        Dim I As Byte

        For I = 0 To (bt_string_Text.Length - 1) 'Rempli le buffer un caractere a la fois

            BufferOut(3 + I) = bt_string_Text(I)

        Next I

        hidWriteEx(VendorID, ProductID, BufferOut(0))

    End Sub

    Public Sub Clear_Display()
        'Byte 0 must be set to 0
        BufferOut(0) = 0

        ' Byte 1 must be set to our command
        BufferOut(1) = &H80

        hidWriteEx(VendorID, ProductID, BufferOut(0))

    End Sub

    Public Sub Scrolling()
        'Byte 0 must be set to 0
        BufferOut(0) = 0

        ' Byte 1 must be set to our command
        BufferOut(1) = &H84

        ' Byte 1 must be set to our command
        BufferOut(2) = Message_TextBox.Text.Length

        hidWriteEx(VendorID, ProductID, BufferOut(0))

    End Sub
    Public Sub Write_bandwidht_to_lcd()

        'Send Total KO/s usage to LCD (ne doit pas dpasser 16 character)
        Convert.ToString(Download_kb)
        Move_cursor(2, 1)

        Select Case (Download_kb.ToString.Length)


            Case 1

                outputString(Download_kb & "     ")

            Case 2

                outputString(Download_kb & "    ")

            Case 3

                outputString(Download_kb & "   ")

            Case 4

                outputString(Math.Round((Download_kb / 1024), 1) & "M ") ' Transforme en Megabyte

            Case 5

                outputString(Math.Round((Download_kb / 1024), 1) & "M ") ' Transforme en Megabyte

        End Select


        'send upload data to LCD

        Move_cursor(10, 1)

        Select Case (Upload_kb.ToString.Length)


            Case 1

                outputString(Upload_kb & "   ")

            Case 2

                outputString(Upload_kb & "  ")

            Case 3

                outputString(Upload_kb & " ")

            Case 4

                outputString(Upload_kb)

        End Select



    End Sub
    Public Sub Move_cursor(ByVal x As Int16, ByVal y As Int16)


        'Byte 0 must be set to 0
        BufferOut(0) = 0

        ' Byte 1 must be set to our command
        BufferOut(1) = &H82

        ' Set the x location
        BufferOut(2) = Convert.ToByte(x)

        ' Set the y location
        BufferOut(3) = Convert.ToByte(y)


        hidWriteEx(VendorID, ProductID, BufferOut(0))

    End Sub

    Public Sub Network_NIC_Name()
        m_performanceCounterCategory = New PerformanceCounterCategory("Network Interface")

        If (Not m_performanceCounterCategory.InstanceExists(NIC_instances_name)) Then
            Throw New ArgumentException("The specified instance doesn't exists")
        End If
        Network_performanceCounter = New PerformanceCounter("Network Interface", "Bytes Received/sec", NIC_instances_name)
        Network_performanceCounter2 = New PerformanceCounter("Network Interface", "Bytes Sent/sec", NIC_instances_name)
        Network_card_selected = True
    End Sub

    Private Sub NIC_SELECT_COMBO_BOX_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NIC_SELECT_COMBO_BOX.SelectedIndexChanged


        Select Case (NIC_SELECT_COMBO_BOX.SelectedIndex)

            Case 0
                NIC_instances_name = NIC_instances(0)
                Network_NIC_Name()
            Case 1
                NIC_instances_name = NIC_instances(1)
                Network_NIC_Name()
            Case 2
                NIC_instances_name = NIC_instances(2)
                Network_NIC_Name()
            Case 3
                NIC_instances_name = NIC_instances(3)
                Network_NIC_Name()
            Case 4
                NIC_instances_name = NIC_instances(4)
                Network_NIC_Name()


        End Select

    End Sub

    Private Sub Message_CheckBox_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Message_CheckBox.Click


        ' timer1.Enabled = False
        timer1.Stop()

        If Message_CheckBox.Checked = True Then


            If String.IsNullOrEmpty(Message_TextBox.Text) Then

                MsgBox("Aucun text dtect!")

            Else


                Clear_Display()
                Move_cursor(0, 0)
                outputString(Message_TextBox.Text)

                Scrolling()




            End If

        End If

        If Message_CheckBox.Checked = False Then

            Scrolling() 'Envoie la commande scrolling encore au PIC pour dsactiv le scrolling
            Clear_Display()
            Set_LCD_Label()
            timer1.Start()

        End If


    End Sub

End Class
